  ''Micromite DLC and RGB LED demo code
  
  ''Demo for Digital Lighting Controller Slave
  ''Outputting serial data giving test patterns
  ''Connect DATA+ to 3.3V and DATA- to pin 10
  ''Also output WS2812 data on pin 9
  
  OPTION AUTORUN ON
  OPTION EXPLICIT
  OPTION BASE 0
  
  ''for Digital Lighting  Controller Serial Data:
  Const DLC_TX_PIN = 10
  CONST DLC_SLAVE_COUNT = 64
  Dim B%(DLC_SLAVE_COUNT) As INTEGER
  DLC_SETUP
  
  ''for WS2812 Strips:
  const LED_PIN = 9   ' pin to connect to the data-in on the WS2812B module
  const NUMLEDS = 64  ' number of LEDs in the WS2812B module chain
  setpin LED_PIN,DOUT ' set the data pin as an output
  DIM INTEGER colours(NUMLEDS) 'set up array to hold the colours for each LED
  '                              ' i.e., colours(0) to colours(NUMLEDS-1)
  PIN(LED_PIN) = 0  ' set LED_PIN low to begin
  CONST MAX_INTENSITY = 40    ''to limit current flow and brightness
  
  DIM PATTERN(16) AS INTEGER    ''arbitrary wave pattern
  PATTERN(0)=0
  PATTERN(1)=32
  PATTERN(2)=64
  PATTERN(3)=96
  PATTERN(4)=128
  PATTERN(5)=160
  PATTERN(6)=192
  PATTERN(7)=224
  PATTERN(8)=255
  PATTERN(9)=224
  PATTERN(10)=192
  PATTERN(11)=160
  PATTERN(12)=128
  PATTERN(13)=96
  PATTERN(14)=64
  PATTERN(15)=32
  
MAIN_LOOP:
  TWINKLE(500,10000)             ''random patterns at 500ms intervals for 10000ms
  MIX(10000)                     ''mixed waves
  FADE(0,255,5000)               ''fade up over 5000ms
  FADE(255,0,5000)               ''fade down over 5000ms
  CHASE(255,0,255,5,500,5000)    ''chase rgb(255,0,255) in steps of 5 for 5000ms
  ALL_ON
  PAUSE 1000
  ALL_OFF
  PAUSE 1000
  GoTo MAIN_LOOP
  
  
SUB TWINKLE(S AS INTEGER, T AS INTEGER)
  LOCAL INTEGER T0,S0,I%
  T0=TIMER
  DO WHILE((TIMER-T0)<T)
    S0=TIMER
    FOR I% = 0 to DLC_SLAVE_COUNT-1
      B%(I%)=0
    NEXT I%
    FOR I% = 0 to DLC_SLAVE_COUNT\8 ''only turn on some
      B%(RND()*DLC_SLAVE_COUNT)=RND()*255
    NEXT I%
    FOR I% = 0 to NUMLEDS-1
      WS2812.setcolour(I%,0,0,0)
    NEXT I%
    FOR I% = 0 to NUMLEDS-1
      WS2812.setcolour(RND()*NUMLEDS,RND()*MAX_INTENSITY,RND()*MAX_INTENSITY,RND()*MAX_INTENSITY)
    NEXT I%
    DLC_SEND_PACKET B%(),DLC_SLAVE_COUNT
    WS2812.Pulses(NUMLEDS,LED_PIN,colours())
    DO WHILE((TIMER-S0)<S)
    LOOP    
  LOOP
END SUB
  
SUB ALL_OFF
  LOCAL INTEGER I%
  FOR I% = 0 to DLC_SLAVE_COUNT-1
    B%(I%)=0
  NEXT I%
  FOR I% = 0 to NUMLEDS-1
    WS2812.setcolour(I%,0,0,0)
  NEXT I%
  DLC_SEND_PACKET B%(),DLC_SLAVE_COUNT
  WS2812.Pulses(NUMLEDS,LED_PIN,colours())
END SUB
  
SUB ALL_ON
  LOCAL INTEGER I%
  FOR I% = 0 to DLC_SLAVE_COUNT-1
    B%(I%)=255
  NEXT I%
  FOR I% = 0 to NUMLEDS-1
    WS2812.setcolour(I%,MAX_INTENSITY,MAX_INTENSITY,MAX_INTENSITY)
  NEXT I%
  DLC_SEND_PACKET B%(),DLC_SLAVE_COUNT
  WS2812.Pulses(NUMLEDS,LED_PIN,colours())
END SUB
  
SUB MIX(T AS INTEGER)   ''mixed patterns for T ms
  LOCAL INTEGER T0,I,J
  T0=TIMER
  J=0
  DO WHILE((TIMER-T0)<T)
    FOR I% = 0 to DLC_SLAVE_COUNT-1
      B%(I%)=PATTERN((I+J) MOD 16)
    NEXT I%
    FOR I% = 0 to NUMLEDS-1
      WS2812.setcolour(I%,MAX_INTENSITY*PATTERN((I+J+5) MOD 16)\256,MAX_INTENSITY*PATTERN((I+J+10) MOD 16)\256,MAX_INTENSITY*PATTERN((I+J) MOD 16)\256)
    NEXT I%
    J=(J+15) MOD 16 ''scroll backwards
    DLC_SEND_PACKET B%(),DLC_SLAVE_COUNT
    WS2812.Pulses(NUMLEDS,LED_PIN,colours())
    PAUSE 50
  LOOP
END SUB
  
SUB FADE(V0 AS INTEGER, V1 AS INTEGER, T AS INTEGER)''fade from v0 to v1 over t
  LOCAL INTEGER T0,F,V
  T0=TIMER
  DO WHILE((TIMER-T0)<T)
    F=(256*(TIMER-T0))\T
    V=(F*V1+(256-F)*V0)\256
    SETALL(V,V,V)
    PAUSE 20
  LOOP
  SETALL(V1,V1,V1)
END SUB
  
SUB SETALL(RED AS INTEGER, GREEN AS INTEGER, BLUE AS INTEGER)
  LOCAL INTEGER I%
  FOR I% = 0 to DLC_SLAVE_COUNT-1
    B%(I%)=(RED+GREEN+BLUE)\3
  NEXT I%
  FOR I% = 0 to NUMLEDS-1
    WS2812.setcolour(I%,(RED*MAX_INTENSITY)\256,(GREEN*MAX_INTENSITY)\256,(BLUE*MAX_INTENSITY)\256)
  NEXT I%
  DLC_SEND_PACKET B%(),DLC_SLAVE_COUNT
  WS2812.Pulses(NUMLEDS,LED_PIN,colours())
END SUB
  
SUB CHASE(RED AS INTEGER, GREEN AS INTEGER, BLUE AS INTEGER, STEPS AS INTEGER, INTERVAL AS INTEGER, T AS INTEGER)
  LOCAL INTEGER I%,S%,STARTTIME,STEPTIME
  S%=0
  STARTTIME=TIMER
  STEPTIME=TIMER
  DO WHILE(TIMER-STARTTIME<T)
    STEPTIME=TIMER
    FOR I%=0 TO DLC_SLAVE_COUNT-1
      IF (I% MOD STEPS) = S% THEN
        B%(I%)=255
      ELSE
        B%(I%)=0
      ENDIF
    NEXT I%
    FOR I%=0 TO NUMLEDS-1
      IF (I% MOD STEPS) = S% THEN
        WS2812.setcolour(I%,GREEN,RED,BLUE)
      ELSE
        WS2812.setcolour(I%,0,0,0)
      ENDIF
    NEXT I%
    S= (S+1) MOD STEPS
    DLC_SEND_PACKET B%(),DLC_SLAVE_COUNT
    WS2812.Pulses(NUMLEDS,LED_PIN,colours())
    DO WHILE(TIMER-STEPTIME<INTERVAL)
    LOOP
  LOOP
END SUB
  
Sub DLC_SETUP
  Pin(DLC_TX_PIN)=1
  SetPin DLC_TX_PIN,DOUT  ''IDLE HIGH
End Sub
  
Sub DLC_SEND_PACKET D%() As INTEGER, N% As INTEGER
  LOCAL STRING S$
  LOCAL INTEGER I%
  S$=CHR$(0)                      ''leading 0 = data to follow
  FOR I% = 1 to N%
    S$=S$+chr$(D%(I%))            ''build up output data
  NEXT I%
  Pin(DLC_TX_PIN)=0               ''start break
  Pause 1                         ''break of ~38 bits
  Pin(DLC_TX_PIN)=1               ''return to mark
  Pause 1                         ''mark after break
  SerialTx(DLC_TX_PIN,38400,S$)   ''send data
  Pin(DLC_TX_PIN)=1               ''return to idle
End Sub
  
CSub SerialTx
  00000008
  00001021 40824800 40024800 0044102b 1440fffd 00000000 03e00008 00000000
  27bdffc8 afb40020 3c149d00 8e820000 afb00010 8c500000 8ca30000 00108042
  0203001b 006001f4 afb10014 8e820010 00808821 8c840000 afbf0034 afb60028
  afb3001c afb20018 00c0b021 24050008 00003021 afbe0030 afb7002c afb50024
  0040f809 00008012 8e240000 8e820014 0040f809 24050001 8e240000 8e820024
  0040f809 24050006 00409021 8e240000 8e820024 0040f809 24050005 00409821
  8e240000 8e820028 0040f809 2610fffb 82c30000 18600027 24110001 00518804
  24150001 ae710000 02002021 0411FFC4 00000000 241e0008 24170001 10000009
  02d5a021 ae510000 02002021 0017b840 27deffff 0411FFBA 00000000 13c0000d
  32f700ff 82820000 02e21024 1440fff5 00000000 ae710000 02002021 0017b840
  27deffff 0411FFAE 00000000 17c0fff5 32f700ff ae510000 02002021 0411FFA8
  00000000 82c20000 02a2102a 1440ffdd 26b50001 8fbf0034 00001021 00001821
  8fbe0030 8fb7002c 8fb60028 8fb50024 8fb40020 8fb3001c 8fb20018 8fb10014
  8fb00010 03e00008 27bd0038
End CSub
  
  
  ' *********************************************************************
  ' WS2812.setcolour: A subroutine to load the colour array element for a
  ' specific LED with the green, red, and blue components. Each colour
  ' component is one byte, so each colour array element has a total of 24
  ' bits. The subroutine is called like this:
  ' WS2812.setcolour(led as int, greenness as int, redness as int, blueness as int)
  '
sub WS2812.setcolour(led as integer, greenness as integer, redness as integer, blueness as integer)
  colours(led) = ((greenness and &HFF)<<16) + ((redness and &HFF)<<8) + (blueness and &HFF)
end sub
  '
  ' *********************************************************************
  ' WS2812.getcolour: A subroutine to get the green, red, and blue
  ' components for a specific LED from the colour array. Called thus:
  ' WS2812.getcolour(led as int, greenness as int, redness as int, blueness as int)
  '
sub WS2812.getcolour(led as integer, greenness as integer, redness as integer, blueness as integer)
  greenness = colours(led)>>16  ' extract green value by moving down by 16 bits
  redness = (colours(led)>>8) and &HFF ' then get red value by moving down by 8
  ' bits, masking off all but lowest 8 bits
  blueness = colours(led) and &HFF     ' then get blue value as lowest 8 bits
end sub
  '
  ' *********************************************************************
  ' CSUB WS2812.Pulses - an embedded C routine written by P. Mathers, used
  ' to drive RGB LED modules based on the WS2812 intelligent LED
  ' called by WS2812.Pulses(NUMLEDS as int, LED_PIN as int, colours() as int)
  ' where NUMLEDS is the number of LEDs, LED_PIN is the Micromite pin used
  ' to drive the serial data input pin of the module, and colours() is
  ' the array used to hold the colours to be displayed by each LED.
  ' Note that each element of the colours() array holds 24 bits of data,
  ' with the first 8 bits representing the green level, the next
  ' 8 bits the red level and the final 8 bits the blue level.
  
Csub WS2812.Pulses
  00000000
  27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C
  AFB20028 AFB10024 AFB00020 3C169D00 8EC20000 3C120057 3652316E 8C420000
  3C100026 261025A0 0052001B 024001F4 3C130026 367325A0 3C110057 2631316E
  AFA5004C 0080A821 8EC30028 8CA40000 AFA60050 00009012 2652FFFF 0050001B
  020001F4 00008012 2610FFFF 0053001B 026001F4 00009812 0051001B 022001F4
  0060F809 00008812 8EA50000 8EC30040 000520C0 00052940 00A42023 24050001
  00452804 0060F809 AFA50018 AFA20010 8EA30000 8EC20040 8FB40010 000320C0
  00031940 0040F809 00642023 0040F021 8FA2004C 24050006 8C440000 8EC20024
  0040F809 03C0B821 8FA3004C AFA20014 8EC20024 8C640000 0040F809 24050005
  8EA30004 1C600006 8FAA0050 1460003F 3C040008 8EA30000 5060003D 3C03BF88
  00006021 10000032 00002021 2463FFFF 25290001 2508FFFF 24E70001 24C60001
  8D450004 8D440000 00035827 00057040 016E7004 00642006 00652807 306B0020
  01C42025 00AB200B 30840001 10800004 00602821 A0F30000 10000003 A0D20000
  A0F10000 A0D00000 1580000A 00000000 14AD0008 00000000 82840000 28850005
  14A00003 2484FFFC 1000FFE0 A2840000 A2800000 0501FFDD 01202021 8EA50004
  258C0001 000C1FC3 0065282A 14A00008 254A0008 8EA50004 54A3000C 3C040008
  8EA30000 0183302B 50C00008 3C040008 24890001 02843821 02E43021 24080016
  24030017 1000FFCE 240D0017 3C03BF88 AC641064 3C03BF88 AC601068 8EA40000
  00001821 000428C0 00042140 00854823 40834800 8FA70018 8FA40014 00003021
  AC870000 8FA50014 00C04021 ACA70000 8FA50010 00A62021 80840000 00641821
  40044800 0064282B 10A0FFFD 00000000 AC470000 03C81821 80630000 24C60001
  00832021 40034800 0064282B 14A0FFFD 00000000 0126202A 5080FFEB 8FA50014
  8FA40018 3C030008 AC440000 8FBF0044 3C02BF88 AC431064 3C02BF88 8FBE0040
  8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C 8FB20028 8FB10024 8FB00020
  AC431068 03E00008 27BD0048
End Csub
  
  ' end of program